<?php

include("../Common/top.php");

include("functions.php");

$PageTitle = 'OT Leads & Campaigns Summary';



if(!in_array('campaigns',$_SESSION["Permissions"])){

header("location:".$WebLink."dashboard.php");	

}

?>

<!DOCTYPE html>

<html>
<head>
<?php include("../Common/meta.php"); ?>
<title>OT Leads & Campaigns Summary | CRM</title>
<?php include("../Common/head.php"); ?>

<!-- Table Responsive css -->

<link href="<?php echo $WebLink; ?>assets/plugins/responsive-table/css/rwd-table.min.css" rel="stylesheet" type="text/css" media="screen">
<style>
#leads th {
	font-size: 12px;
	padding: 5px;
	white-space: normal;
	width: 160px;
}
#leads td {
	font-size: 12px;
	padding: 5px;
	white-space: normal;
}
#tech-companies-1 th {
	padding: 5px;
}
.table-responsive {
	width: 50%;
}
input, select {
	margin: 2px;
}
</style>
</head>

<body class="fixed-left">

<!-- Begin page -->

<div id="wrapper">

<!-- Top Bar Start -->

<?php include("../Common/topbar.php"); ?>

<!-- Top Bar End --> 

<!-- ========== Left Sidebar Start ========== -->

<?php include("../Common/left-sidebar.php"); ?>

<!-- Left Sidebar End --> 

<!-- ============================================================== --> 

<!-- Start right Content here --> 

<!-- ============================================================== -->

<div class="content-page"> 
  
  <!-- Start content -->
  
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="card-box">
            <div class="table-rep-plugin">
              <div class="table-responsive" data-pattern="priority-columns">
                <table id="tech-companies-1" class="table  table-striped">
                  <thead>
                    <tr>
                      <th>Platforms</th>
                      <th data-priority="3" style="max-width:100px;">Spendings</th>
                      <th data-priority="3" style="max-width:100px;">Clicks</th>
                      <th data-priority="3" style="max-width:100px;">All Leads</th>
                      <th data-priority="3" style="max-width:100px;">Qualified Leads</th>
                      <th data-priority="3" style="max-width:100px;">- CPQ</th>
                      <th data-priority="3" style="max-width:100px;"> - Ratio</th>
                      <th data-priority="3" style="max-width:100px;">Customers</th>
                      <th data-priority="3" style="max-width:100px;"> - Ratio</th>
                      <th data-priority="3" style="max-width:100px;"> - CPC</th>
                    </tr>
                  </thead>
                  <tbody id="leads">
                      <?php
                      $Platform_Query = mysqli_query($_SESSION["con"], "SELECT * FROM importanttitles WHERE MainQueryType = 2 ORDER BY id ASC");
                        
                      while($Platform_Fetch = mysqli_fetch_array($Platform_Query)){
                      
                      
                      $CampaignsSummary_Query = mysqli_query($_SESSION["con"], "SELECT SUM(Spending) AS TotalSpending, SUM(Clicks) AS TotalClicks FROM CampaignsData WHERE MainQuerySource = '".$Platform_Fetch["id"]."'");
                      $CampaignsSummary_Fetch = mysqli_fetch_array($CampaignsSummary_Query);
                      
                      $LeadsData_Query = mysqli_query($_SESSION["con"], "SELECT COUNT(id) AS TotalLeads FROM leads WHERE MainQuerySource = '".$Platform_Fetch["id"]."'"); 
                      $LeadsData_Fetch = mysqli_fetch_assoc($LeadsData_Query);
                      
                      
                      $QLeadsData_Query = mysqli_query($_SESSION["con"], "SELECT COUNT(id) AS TotalQLeads FROM leads WHERE Status != '98' AND MainQuerySource = '".$Platform_Fetch["id"]."'"); 
                      $QLeadsData_Fetch = mysqli_fetch_assoc($QLeadsData_Query);
                      
                      $QLeadsRatio = ($QLeadsData_Fetch["TotalQLeads"] / $LeadsData_Fetch["TotalLeads"]) * 100;
                        
                      $CPQ = $CampaignsSummary_Fetch["TotalSpending"] / $QLeadsData_Fetch["TotalQLeads"];
                      
                      $CustomersData_Query = mysqli_query($_SESSION["con"], "SELECT COUNT(id) AS TotalCustomers FROM leads WHERE (Status = '92' OR Status = '91') AND MainQuerySource = '".$Platform_Fetch["id"]."'"); 
                      
                      $CustomersData_Fetch = mysqli_fetch_assoc($CustomersData_Query);
                        
                      $CustomersRatio = ($CustomersData_Fetch["TotalCustomers"] / $QLeadsData_Fetch["TotalQLeads"]) * 100;
                        
                      $CPC = $CampaignsSummary_Fetch["TotalSpending"] / $CustomersData_Fetch["TotalCustomers"];
                      ?>
                      <tr>
                        <th><?php echo $Platform_Fetch["Title"]; ?></th>
                        <td class="tech-companies-1-col-2" style="max-width:50px;"><?php echo round($CampaignsSummary_Fetch["TotalSpending"], 2); ?></td>
                        <td class="tech-companies-1-col-3" style="max-width:50px;"><?php echo $CampaignsSummary_Fetch["TotalClicks"]; ?></td>
                        <td class="tech-companies-1-col-4" style="max-width:50px;"><?php echo $LeadsData_Fetch["TotalLeads"]; ?></td>
                        <td class="tech-companies-1-col-5" style="max-width:50px;"><?php echo $QLeadsData_Fetch["TotalQLeads"]; ?></td>
                        <td class="tech-companies-1-col-6" style="max-width:50px;"><?php  if($CPQ == "0" || is_infinite($CPQ) || is_nan($CPQ)){ echo "0"; }else{ echo round($CPQ, 2); } ?></td>
                        <td class="tech-companies-1-col-6" style="max-width:50px;"><?php if($QLeadsRatio == "0" || is_nan($QLeadsRatio)){ echo "0"; }else{ echo round($QLeadsRatio, 2); } ?>%</td>
                        <td class="tech-companies-1-col-7" style="max-width:50px;"><?php echo $CustomersData_Fetch["TotalCustomers"]; ?></td>
                        <td class="tech-companies-1-col-8" style="max-width:50px;"><?php if($CustomersRatio == "0" || is_nan($CustomersRatio)){ echo "0"; }else{ echo round($CustomersRatio, 2); } ?>%</td>
                        <td class="tech-companies-1-col-6" style="max-width:50px;"><?php if($CPC == "0" || is_infinite($CPC) || is_nan($CPC)){ echo "0"; }else{ echo round($CPC, 2); }  ?></td>
                      </tr>
                      <?php
                      $LeadsDataYearly_Query = mysqli_query($_SESSION["con"], "SELECT YEAR(STR_TO_DATE(QueryDate, '%m/%d/%Y')) AS Year, COUNT(id) AS TotalLeads FROM leads WHERE MainQuerySource = '".$Platform_Fetch["id"]."' GROUP BY YEAR(STR_TO_DATE(QueryDate, '%m/%d/%Y')) ORDER BY id DESC");
                        
                      while($LeadsDataYearly_Fetch = mysqli_fetch_array($LeadsDataYearly_Query)){
                      
                      $CampaignsSummaryYearly_Query = mysqli_query($_SESSION["con"], "SELECT SUM(Spending) AS TotalSpending, SUM(Clicks) AS TotalClicks FROM CampaignsData WHERE MainQuerySource = '".$Platform_Fetch["id"]."' AND YEAR(STR_TO_DATE(SpendingDate, '%m/%d/%Y')) = '". $LeadsDataYearly_Fetch["Year"]."'");
                      
                      
                      $CampaignsSummaryYearly_Fetch = mysqli_fetch_assoc($CampaignsSummaryYearly_Query);
                      
                      $QLeadsDataYearly_Query = mysqli_query($_SESSION["con"], "SELECT COUNT(id) AS TotalQLeads FROM leads WHERE Status != '98' AND MainQuerySource = '".$Platform_Fetch["id"]."' AND YEAR(STR_TO_DATE(QueryDate, '%m/%d/%Y')) = '". $LeadsDataYearly_Fetch["Year"]."'");
                     
                      $QLeadsDataYearly_Fetch = mysqli_fetch_assoc($QLeadsDataYearly_Query);
                      
                      $QLeadsRatioYearly = ($QLeadsDataYearly_Fetch["TotalQLeads"] / $LeadsDataYearly_Fetch["TotalLeads"]) * 100;
                        
                      $CPQYearly = $CampaignsSummaryYearly_Fetch["TotalSpending"] / $QLeadsDataYearly_Fetch["TotalQLeads"];
                      
                      $CustomersDataYearly_Query = mysqli_query($_SESSION["con"], "SELECT COUNT(id) AS TotalCustomers FROM leads WHERE (Status = '92' OR Status = '91') AND MainQuerySource = '".$Platform_Fetch["id"]."' AND YEAR(STR_TO_DATE(QueryDate, '%m/%d/%Y')) = '". $LeadsDataYearly_Fetch["Year"]."'"); 
                      
                      $CustomersDataYearly_Fetch = mysqli_fetch_assoc($CustomersDataYearly_Query);
                        
                      $CustomersRatioYearly = ($CustomersDataYearly_Fetch["TotalCustomers"] / $QLeadsDataYearly_Fetch["TotalQLeads"]) * 100;
                        
                      $CPCYearly = $CampaignsSummaryYearly_Fetch["TotalSpending"] / $CustomersDataYearly_Fetch["TotalCustomers"];
                      
                      /*$CampaignsSummary_Query = mysqli_query($_SESSION["con"], "SELECT SUM(Spending) AS TotalSpending, SUM(Clicks) AS TotalClicks FROM CampaignsData WHERE MainQuerySource = '".$Platform_Fetch["id"]."'");
                      $CampaignsSummary_Fetch = mysqli_fetch_array($CampaignsSummary_Query);
                      
                      $LeadsData_Query = mysqli_query($_SESSION["con"], "SELECT COUNT(id) AS TotalLeads FROM leads WHERE MainQuerySource = '".$Platform_Fetch["id"]."'"); 
                      $LeadsData_Fetch = mysqli_fetch_assoc($LeadsData_Query);
                      
                      
                      $QLeadsData_Query = mysqli_query($_SESSION["con"], "SELECT COUNT(id) AS TotalQLeads FROM leads WHERE Status != '98' AND MainQuerySource = '".$Platform_Fetch["id"]."'"); 
                      $QLeadsData_Fetch = mysqli_fetch_assoc($QLeadsData_Query);
                      
                      $QLeadsRatio = ($QLeadsData_Fetch["TotalQLeads"] / $LeadsData_Fetch["TotalLeads"]) * 100;
                        
                      $CPQ = $CampaignsSummary_Fetch["TotalSpending"] / $QLeadsData_Fetch["TotalQLeads"];
                      
                      $CustomersData_Query = mysqli_query($_SESSION["con"], "SELECT COUNT(id) AS TotalCustomers FROM leads WHERE (Status = '92' OR Status = '91') AND MainQuerySource = '".$Platform_Fetch["id"]."'"); 
                      $CustomersData_Fetch = mysqli_fetch_assoc($CustomersData_Query);
                        
                      $CustomersRatio = ($CustomersData_Fetch["TotalCustomers"] / $QLeadsData_Fetch["TotalQLeads"]) * 100;
                        
                      $CPC = $CampaignsSummary_Fetch["TotalSpending"] / $CustomersData_Fetch["TotalCustomers"];
                      */
                      ?>
                      <tr>
                        <th><a href="campaign-summary-monthly.php?y=<?php echo $LeadsDataYearly_Fetch["Year"]; ?>" target="_blank"> -- <?php echo $LeadsDataYearly_Fetch["Year"]; ?></a> </th>
                        <td class="tech-companies-1-col-2" style="max-width:50px;"><?php echo round($CampaignsSummaryYearly_Fetch["TotalSpending"], 2); ?></td>
                        <td class="tech-companies-1-col-3" style="max-width:50px;"><?php echo $CampaignsSummaryYearly_Fetch["TotalClicks"]; ?></td>
                        <td class="tech-companies-1-col-4" style="max-width:50px;"><?php echo $LeadsDataYearly_Fetch["TotalLeads"]; ?></td>
                        <td class="tech-companies-1-col-5" style="max-width:50px;"><?php echo $QLeadsDataYearly_Fetch["TotalQLeads"]; ?></td>
                        <td class="tech-companies-1-col-6" style="max-width:50px;"><?php  if($CPQYearly == "0" || is_infinite($CPQYearly) || is_nan($CPQYearly)){ echo "0"; }else{ echo round($CPQYearly, 2); } ?></td>
                        <td class="tech-companies-1-col-6" style="max-width:50px;"><?php if($QLeadsRatioYearly == "0" || is_nan($QLeadsRatioYearly)){ echo "0"; }else{ echo round($QLeadsRatioYearly, 2); } ?>%</td>
                        <td class="tech-companies-1-col-7" style="max-width:50px;"><?php echo $CustomersDataYearly_Fetch["TotalCustomers"]; ?></td>
                        <td class="tech-companies-1-col-8" style="max-width:50px;"><?php if($CustomersRatioYearly == "0" || is_nan($CustomersRatioYearly)){ echo "0"; }else{ echo round($CustomersRatioYearly, 2); } ?>%</td>
                        <td class="tech-companies-1-col-6" style="max-width:50px;"><?php if($CPCYearly == "0" || is_infinite($CPCYearly) || is_nan($CPCYearly)){ echo "0"; }else{ echo round($CPCYearly, 2); }  ?></td>
                      </tr>
                      
                    <?php } ?> 
                    <?php } ?> 
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        
        <!-- end row --> 
        
      </div>
      
      <!-- container --> 
      
    </div>
    
    <!-- content -->
    
    <footer class="footer text-right"> <?php echo $footer_copyrights; ?> </footer>
  </div>
  
  <!-- ============================================================== --> 
  
  <!-- End Right content here --> 
  
  <!-- ============================================================== --> 
  
  <!-- Right Sidebar -->
  
  <?php include("../Common/right-sidebar.php"); ?>
  
  <!-- /Right-bar --> 
  
</div>

<!-- END wrapper -->

<?php include("../Common/footer.php"); ?>

<!-- responsive-table--> 

<script src="<?php echo $WebLink; ?>assets/plugins/responsive-table/js/rwd-table.min.js" type="text/javascript"></script> 
<script src="<?php echo $WebLink; ?>assets/js/jquery.doubleScroll.js" type="text/javascript"></script> 
<script>

function responsiveTableHideShow(){

	if($(".checkbox-row #toggle-tech-companies-1-col-1").is(':checked')){

		$(".tech-companies-1-col-1").show();

	}else{

		$(".tech-companies-1-col-1").hide();

	}

	if($(".checkbox-row #toggle-tech-companies-1-col-2").is(':checked')){

		$(".tech-companies-1-col-2").show();

	}else{

		$(".tech-companies-1-col-2").hide();

	}

	if($(".checkbox-row #toggle-tech-companies-1-col-3").is(':checked')){

		$(".tech-companies-1-col-3").show();

	}else{

		$(".tech-companies-1-col-3").hide();

	}

	if($(".checkbox-row #toggle-tech-companies-1-col-4").is(':checked')){

		$(".tech-companies-1-col-4").show();

	}else{

		$(".tech-companies-1-col-4").hide();

	}

	if($(".checkbox-row #toggle-tech-companies-1-col-5").is(':checked')){

		$(".tech-companies-1-col-5").show();

	}else{

		$(".tech-companies-1-col-5").hide();

	}

	if($(".checkbox-row #toggle-tech-companies-1-col-6").is(':checked')){

		$(".tech-companies-1-col-6").show();

	}else{

		$(".tech-companies-1-col-6").hide();

	}

	if($(".checkbox-row #toggle-tech-companies-1-col-7").is(':checked')){

		$(".tech-companies-1-col-7").show();

	}else{

		$(".tech-companies-1-col-7").hide();

	}

	if($(".checkbox-row #toggle-tech-companies-1-col-8").is(':checked')){

		$(".tech-companies-1-col-8").show();

	}else{

		$(".tech-companies-1-col-8").hide();

	}
	
	if($(".checkbox-row #toggle-tech-companies-1-col-9").is(':checked')){

		$(".tech-companies-1-col-9").show();

	}else{

		$(".tech-companies-1-col-9").hide();

	}
	
	if($(".checkbox-row #toggle-tech-companies-1-col-10").is(':checked')){

		$(".tech-companies-1-col-10").show();

	}else{

		$(".tech-companies-1-col-10").hide();

	}

}



$(document).ready(function(){

$('.table-responsive').doubleScroll();

});

</script>
<?php include("../Common/bottom.php"); ?>
</body>
</html>