<?php
include("../Common/top.php");
include("functions.php");
$PageTitle = 'Sales Funnel';
?>

<!DOCTYPE html>

<html>
<head>
<?php include("../Common/meta.php"); ?>
<title>Sales Funnel | CRM</title>
<?php include("../Common/head.php"); ?>

<!-- Custom box (Modal) css -->
<link href="<?php echo $WebLink; ?>assets/plugins/custombox/dist/custombox.min.css" rel="stylesheet">
<!-- Dragula (Drag and drop) css -->
<link href="<?php echo $WebLink; ?>assets/plugins/dragula/dragula.min.css" rel="stylesheet">

<style>
    .kanban-box .kanban-detail {
        margin-left: 0px;
    }
    .kanban-box .kanban-detail h4 {
        font-size: 11px;
        margin-bottom: 0px;
    }
    .card-box {
        padding: 5px;
        margin-top: 5px;
        margin-bottom: 0px;
    }
    dl, ol, ul {
        padding: 0px;
    }
</style>
</head>

<body class="fixed-left">

<!-- Begin page -->

<div id="wrapper">

<!-- Top Bar Start -->

<?php include("../Common/topbar.php"); ?>

<!-- Top Bar End --> 

<!-- ========== Left Sidebar Start ========== -->

<?php include("../Common/left-sidebar.php"); ?>

<!-- Left Sidebar End --> 

<!-- ============================================================== --> 

<!-- Start right Content here --> 

<!-- ============================================================== -->

<div class="content-page"> 
  
  <!-- Start content -->
  
  <div class="content">
    <div class="container-fluid">
      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-xl-4">
              <div class="card-box taskboard-box">
                <h4 class="m-t-5 text-primary text-center">Contacts</h4><input type="text" name="search" id="search-drag-upcoming" class="form-control" placeholder="Search" onChange="loadData('SalesFunnel','','drag-upcoming',1);">
                <input type="hidden" name="CurrentPage" name="CurrentPage" value="1">
                <ul class="list-unstyled task-list" id="drag-upcoming">
                </ul>
                <div>
                Showing <span id="pageFrom_drag-upcoming">1</span> to <span id="pageTo_drag-upcoming">58</span> of <span id="pageTotal_drag-upcoming">58</span> Entries</div>
                <div class="dataTables_paginate paging_simple_numbers">
                    <ul class="drag-upcoming-pagination">
                    </ul>
                  </div>
              </div>
            </div>
            <!-- end col -->
            
            <div class="col-xl-4">
              <div class="card-box taskboard-box">
                <h4 class="m-t-5 text-warning text-center">Potential Customers</h4><input type="text" name="search" id="search-drag-inprogress" class="form-control" placeholder="Search" onChange="loadData('SalesFunnel','inprogress','drag-inprogress',1);">
                <ul class="list-unstyled task-list" id="drag-inprogress">
                  
                </ul>
                <div>
                Showing <span id="pageFrom_drag-inprogress">1</span> to <span id="pageTo_drag-inprogress">58</span> of <span id="pageTotal_drag-inprogress">58</span> Entries</div>
                <ul class="drag-inprogress-pagination">
                </ul>
              </div>
            </div>
            <!-- end col -->
            
            <div class="col-xl-4">
              <div class="card-box taskboard-box">
                <h4 class="m-t-5 text-success text-center">Customers</h4><input type="text" name="search" id="search-drag-complete" class="form-control" placeholder="Search" onChange="loadData('SalesFunnel','complete','drag-complete',1);">
                <ul class="list-unstyled task-list" id="drag-complete">
                  
                </ul>
                <div>
                Showing <span id="pageFrom_drag-complete">1</span> to <span id="pageTo_drag-complete">58</span> of <span id="pageTotal_drag-complete">58</span> Entries</div>
                
                <ul class="drag-complete-pagination">
                </ul>
              </div>
            </div>
            <!-- end col --> 
            <button type="button" class="btn btn-success waves-effect waves-light" onclick="SaveSalesFunnel();" style=" width: 60%;margin: 20px auto;">Save Changes</button>
          </div>
          <!-- end row --> 
          
        </div>
        <!-- container --> 
        
      </div>
      
      <!-- container --> 
      
    </div>
    <!-- content -->
    
    <footer class="footer text-right"> <?php echo $footer_copyrights; ?> </footer>
  </div>
  
  <!-- ============================================================== --> 
  
  <!-- End Right content here --> 
  
  <!-- ============================================================== --> 
  
  <!-- Right Sidebar -->
  
  <?php include("../Common/right-sidebar.php"); ?>
  
  <!-- /Right-bar --> 
  
</div>

<!-- END wrapper -->

<?php include("../Common/footer.php"); ?>

<!-- responsive-table--> 
<script>
$(document).ready(function(){
loadData('SalesFunnel','','drag-upcoming',1);
loadData('SalesFunnel','inprogress','drag-inprogress',1);
loadData('SalesFunnel','complete','drag-complete',1);
});
function loadData(action,value1,show,page=1,filter=false){
	$('#CurrentPage').val(page);
	$.ajax({
		type:'POST',
		url:'ajaxData.php',
		dataType: 'json',
		data:"action=" + action + '&value1=' + value1 + "&show=" + show + "&page=" + page + "&Search=" + $('#search-'+show).val(),
		success:function(data){
			$('#'+show).html(data.rows);
			$('#pageFrom_'+show).html((data.LimitFrom + 1));
			$('#pageTo_'+show).html(data.LimitTotal);
			$('#pageTotal_'+show).html(data.TotalRecords);
			$('.'+show+'-pagination').html(data.pagination);
		}
	});
}

function SaveSalesFunnel(){

var upcoming = new Array();
$('#drag-upcoming>li').each(function() {
	upcoming.push($(this).attr("id"));
});

var inprogress = new Array();
$('#drag-inprogress>li').each(function() {
	inprogress.push($(this).attr("id"));
});

var complete = new Array();
$('#drag-complete>li').each(function() {
	complete.push($(this).attr("id"));
});

$.ajax({
	type:'POST',
	url:'ajaxData.php',
	dataType: 'json',
	data:"action=SaveSalesFunnel&upcoming=" + upcoming + "&inprogress=" + inprogress + "&complete=" + complete,
	success:function(data){
		//$('#'+show).html(data.rows);
		//$('.'+show+'-pagination').html(data.pagination);
		getNotifications('load');
	}
});
	
//console.dir(upcoming);
//console.dir(inprogress);
//console.dir(complete);
}
</script> 

<!-- drgula (Drag and drop) js --> 
<script src="<?php echo $WebLink; ?>assets/plugins/dragula/dragula.min.js"></script> 

<script type="text/javascript">
    dragula([document.querySelector('#drag-upcoming'), document.querySelector('#drag-inprogress'), document.querySelector('#drag-complete')], {
        isContainer: function (el) {
            return false; // only elements in drake.containers will be taken into account
        },
        moves: function (el, source, handle, sibling) {
            return true; // elements are always draggable by default
        },
        accepts: function (el, target, source, sibling) {
			console.dir(target.id);
			
            return true; // elements can be dropped in any of the `containers` by default
        },
        invalid: function (el, handle) {
            return false; // don't prevent any drags from initiating by default
        },
        direction: 'vertical',             // Y axis is considered when determining where an element would be dropped
        copy: false,                       // elements are moved by default, not copied
        copySortSource: false,             // elements in copy-source containers can be reordered
        revertOnSpill: false,              // spilling will put the element back where it was dragged from, if this is true
        removeOnSpill: false,              // spilling will `.remove` the element, if this is true
        mirrorContainer: document.body,    // set the element that gets mirror elements appended
        ignoreInputTextSelection: true     // allows users to select input text, see details below
    });
	
	function salesFunnelUpdate(){
		console.log('OK');
	}
	
</script>
<?php include("../Common/bottom.php"); ?>
</body>
</html>