<?php
/*$func = (!empty($_GET["func"])) ? $_GET["func"] : "view";
$folder = (!empty($_GET["folder"])) ? $_GET["folder"] : "INBOX";
$uid = (!empty($_GET["uid"])) ? $_GET["uid"] : 0;*/

function getBody($uid, $imap) {
    $body = get_part($imap, $uid, "TEXT/HTML");
    // if HTML body is empty, try getting text body
    if ($body == "") {
        $body = get_part($imap, $uid, "TEXT/PLAIN");
    }
    return $body;
}

function get_part($imap, $uid, $mimetype, $structure = false, $partNumber = false) {
    if (!$structure) {
           $structure = imap_fetchstructure($imap, $uid, FT_UID);
    }
    if ($structure) {
        if ($mimetype == get_mime_type($structure)) {
            if (!$partNumber) {
                $partNumber = 1;
            }
            $text = imap_fetchbody($imap, $uid, $partNumber, FT_UID);
            switch ($structure->encoding) {
                case 3: return imap_base64($text);
                case 4: return imap_qprint($text);
                default: return $text;
           }
       }

        // multipart 
        if ($structure->type == 1) {
            foreach ($structure->parts as $index => $subStruct) {
                $prefix = "";
                if ($partNumber) {
                    $prefix = $partNumber . ".";
                }
                $data = get_part($imap, $uid, $mimetype, $subStruct, $prefix . ($index + 1));
                if ($data) {
                    return $data;
                }
            }
        }
    }
    return false;
}

function get_mime_type($structure) {
    $primaryMimetype = array("TEXT", "MULTIPART", "MESSAGE", "APPLICATION", "AUDIO", "IMAGE", "VIDEO", "OTHER");

    if ($structure->subtype) {
       return $primaryMimetype[(int)$structure->type] . "/" . $structure->subtype;
    }
    return "TEXT/PLAIN";
}

function getPaginations($query,$rowsperpage,$currentpage){
	
	$query_new = mysqli_query($_SESSION["con"], $query);
    $numrows = mysqli_num_rows($query_new);
	
	// find out total pages
	$totalpages = ceil($numrows / $rowsperpage);

	// get the current page or set a default
	if (isset($currentpage) && is_numeric($currentpage)) {
	   // cast var as int
	   $currentpage = (int) $currentpage;
	} else {
	   // default page num
	   $currentpage = 1;
	} // end if
	
	// if current page is greater than total pages...
	if ($currentpage > $totalpages) {
	   // set current page to last page
	   $currentpage = $totalpages;
	} // end if
	// if current page is less than first page...
	if ($currentpage < 1) {
	   // set current page to first page
	   $currentpage = 1;
	} // end if
	
	// the offset of the list, based on current page 
	$offset = ($currentpage - 1) * $rowsperpage;
	
	$paginations_data = array();
	
	$paginations_data['LimitFrom'] = $offset;
	
	$paginations_data['LimitTo'] = $rowsperpage;
	
	$paginations_data['LimitTotal'] = $offset + $rowsperpage;
	
	if($paginations_data['LimitTotal'] > $numrows) $paginations_data['LimitTotal'] = $numrows;
	
	$paginations_data['TotalRecords'] = $numrows;
	
	/******  build the pagination links ******/
	// range of num links to show
	$range = 3;
	
	// if not on page 1, don't show back links
	if ($currentpage > 1) {
	   // show << link to go back to page 1
	   $paginations_data['firstPage'] = 1;
	   // get previous page num
	   $prevpage = $currentpage - 1;
	   // show < link to go back to 1 page
	   $paginations_data['PreviousPage'] = $prevpage;
	} // end if 
	
	// loop to show links to range of pages around current page
	for ($x = ($currentpage - $range); $x < (($currentpage + $range) + 1); $x++) {
	   // if it's a valid page number...
	   if (($x > 0) && ($x <= $totalpages)) {
		  // if we're on current page...
		  if ($x == $currentpage) {
			 // 'highlight' it but don't make a link
			 $paginations_data['CurrentPage'] = $x;
			 $paginations_data['Pages'][] = $x;
		  // if not current page...
		  } else {
			 // make it a link
			 $paginations_data['Pages'][] = $x;
		  } // end else
	   } // end if 
	} // end for
	
	// if not on last page, show forward and last page links        
	if ($currentpage != $totalpages) {
	   // get next page
	   $nextpage = $currentpage + 1;
		// echo forward link for next page 
	   $paginations_data['NextPage'] = $nextpage;
	   // echo forward link for lastpage
	   $paginations_data['LastPage'] = $totalpages;
	} // end if
	
	return $paginations_data;
	
	}