<?php
include("../Common/top.php");
include("functions.php");
$PageTitle = 'Potential Customers';

$salesperson_id = $_GET['salesperson_id'];
$status = $_GET['status'];
$manager_name = urldecode($_GET['manager_name']);

$statusMapping = [
    '91' => 'Shipped',
    '92' => 'Advance Received',
    '93' => 'PI Counter Signed',
    '94' => 'PI Issued',
    '95' => 'Negotiation',
    '96' => 'Price Quoted',
    '97' => 'In Process'
];

// Set the display status based on the value of $status
$displayStatus = isset($statusMapping[$status]) ? $statusMapping[$status] : 'Unknown Status';


// Updated query with the leadsdiscussion join to get the latest remark
$query = "
    SELECT 
    l.ContactPerson, 
    l.CompanyName, 
    l.Country, 
    l.Market, 
    u.ContactPerson AS FollowupPerson, 
    l.Status, 
    l.AssingLeadDate,
    ld.Comment,
    ld.PostDate AS RemarkDate  -- Include PostDate for the remark
    
FROM leads l
JOIN users u ON l.FollowupID = u.id
LEFT JOIN (
    SELECT ld1.QueryID, ld1.ContactPerson, ld1.Comment, ld1.PostDate  -- Select PostDate
    FROM leadsdiscussion ld1
    JOIN (
        -- Subquery to get the latest PostDate for each leadid and ContactPerson
        SELECT QueryID, ContactPerson, MAX(PostDate) AS LatestPostDate
        FROM leadsdiscussion
        GROUP BY QueryID, ContactPerson
    ) ld2 ON ld1.QueryID = ld2.QueryID 
         AND ld1.ContactPerson = ld2.ContactPerson 
         AND ld1.PostDate = ld2.LatestPostDate
) ld ON l.id = ld.QueryID AND l.FollowupID = ld.ContactPerson
    WHERE l.AssignManager = '".$salesperson_id."' 
      AND l.Status = ".$status.";
";

$result = $_SESSION["con"]->query($query);
?>

<!DOCTYPE html>

<html>
<head>
<?php include("../Common/meta.php"); ?>
<title>Potential Customers - Leads | CRM</title>
<?php include("../Common/head.php"); ?>

<!-- Table Responsive css -->
<link href="<?php echo $WebLink; ?>assets/plugins/responsive-table/css/rwd-table.min.css" rel="stylesheet" type="text/css" media="screen">
<style>
#leads th {
	font-size: 12px;
	padding: 5px;
	white-space: normal;
	width: 160px;
}
#leads td {
	font-size: 12px;
	padding: 5px;
	white-space: normal;
}
#tech-companies-1 th {
	padding: 5px;
}
.table-responsive {
	width: 50%;
}
</style>

</head>

<body class="fixed-left">

<!-- Begin page -->
<div id="wrapper">

<!-- Top Bar Start -->
<?php include("../Common/topbar.php"); ?>
<!-- Top Bar End --> 

<!-- ========== Left Sidebar Start ========== -->
<?php include("../Common/left-sidebar.php"); ?>
<!-- Left Sidebar End --> 

<div class="content-page"> 
  <!-- Start content -->
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="card-box">
              <h3>Manager : <?php echo $manager_name; ?></h3>
              <h4>Status : <?php echo $displayStatus; ?></h4></br>
            <div class="table-rep-plugin">
              <div class="table-responsive" data-pattern="priority-columns">
                <table id="tech-companies-1" class="table  table-striped">
                  <thead>
                    <tr>
                      <th>Contact Person</th>
                      <th data-priority="3" style="max-width:200px;">Company Name</th>
                      <th data-priority="1" style="max-width:100px;">Country</th>
                      <th data-priority="1" style="max-width:100px;">Market</th>
                      <th data-priority="1" style="max-width:100px">Followup</th>
                      <th data-priority="1" style="max-width:100px">AssingLead Date</th>
                      <th data-priority="1" style="max-width:100px">Remarks Date</th>
                      <th data-priority="1" style="max-width:100px">Remarks</th>
                    </tr>
                  </thead>
                  <tbody id="leads">
                    <?php while($row = $result->fetch_assoc()) { ?>
                <tr>
                    <td><?php echo $row['ContactPerson']; ?></td>
                    <td><?php echo $row['CompanyName']; ?></td>
                    <td><?php echo $row['Country']; ?></td>
                    <td><?php echo $row['Market']; ?></td>
                    <td><?php echo $row['FollowupPerson']; ?></td>
                    <td><?php echo $row['AssingLeadDate']; ?></td>
                    <td><?php echo date('d-m-Y H:i:s', strtotime($row['RemarkDate'] . ' +4 hours')); ?></td>
                    <td><?php echo $row['Comment']; ?></td>
                </tr>
                <?php } ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <!-- end row --> 
      </div>
      <!-- container --> 
    </div>
    <!-- content -->
    <footer class="footer text-right"> <?php echo $footer_copyrights; ?> </footer>
  </div>
</div>

<!-- Right Sidebar -->
<?php include("../Common/right-sidebar.php"); ?>
<!-- /Right-bar --> 

</div>
<!-- END wrapper -->

<?php include("../Common/footer.php"); ?>

<?php include("../Common/bottom.php"); ?>
</body>
</html>
