<?php
// Database connection parameters
$servername = "localhost";
$username = "trojanli_crmmoiz";
$password = "}]GxQMzUUsgw";
$dbname = "trojanli_crmmoiz";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Function to fetch existing tags for a specific lead
function getExistingTags($lead_id) {
    global $conn;
    $sql = "SELECT Tags FROM leads WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $lead_id);
    $stmt->execute();
    $stmt->bind_result($tagsString);
    $stmt->fetch();
    $stmt->close();

    // Convert the comma-separated string back into an array
    return $tagsString ? explode(", ", $tagsString) : [];
}

// Function to insert selected tags into the 'leads' table
function addTagsToLead($lead_id, $tags) {
    global $conn;

    // Convert the tags array to a comma-separated string
    $tagsString = implode(", ", $tags);

    // Prepare the SQL query to update the Tags column for the specific lead
    $stmt = $conn->prepare("UPDATE leads SET Tags = ? WHERE id = ?");
    $stmt->bind_param("si", $tagsString, $lead_id);

    // Execute the query
    if ($stmt->execute()) {
        echo "Tags added successfully to lead with ID: $lead_id<br>";
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
}

// Handle tag update form submission
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['tags'])) {
    $tags = $_POST['tags']; // Array of selected tags
    $lead_id = $_POST['lead_id']; // The ID of the lead you are updating
    addTagsToLead($lead_id, $tags);
}

// Get existing tags for a specific lead (you can change this ID as needed)
$lead_id = 1; // Replace with the actual Lead ID you want to check
$existingTags = getExistingTags($lead_id);

// Close connection
$conn->close();
?>

<!-- HTML Form without Dropdown, with Static Lead ID Heading -->
<form method="POST" action="">
    <h3>Lead ID: <?php echo $lead_id; ?></h3> <!-- Display Lead ID -->
    <input type="hidden" name="lead_id" value="<?php echo $lead_id; ?>"> <!-- Hidden input to send the Lead ID -->

    <div id="tags-section">
        <label>Select Tags:</label><br>
        <input type="checkbox" id="market_close" name="tags[]" value="Market Close" <?php echo in_array("Market Close", $existingTags) ? 'checked' : ''; ?>>
        <label for="market_close">Market Close</label><br>

        <input type="checkbox" id="no_brand_available" name="tags[]" value="No Brand Available" <?php echo in_array("No Brand Available", $existingTags) ? 'checked' : ''; ?>>
        <label for="no_brand_available">No Brand Available</label><br>

        <input type="checkbox" id="anti_dumping" name="tags[]" value="Anti Dumping" <?php echo in_array("Anti Dumping", $existingTags) ? 'checked' : ''; ?>>
        <label for="anti_dumping">Anti Dumping</label><br>
    </div>

    <button type="submit">Add Tags</button>
</form>