<?php include("../Common/top.php");
$PageTitle = 'Events';

if(!in_array('events',$_SESSION["Permissions"])){
header("location:".$WebLink."dashboard.php");	
}
?>

<!DOCTYPE html>

<html>

<head>

<?php include("../Common/meta.php"); ?>

<title>Events Calendar | CRM</title>

<!--calendar css-->

<link href="<?php echo $WebLink; ?>assets/plugins/fullcalendar/css/fullcalendar.min.css" rel="stylesheet" />

<?php include("../Common/head.php"); ?>

</head>

<body class="fixed-left">

<!-- Begin page -->

<div id="wrapper">

  <!-- Top Bar Start -->

  <?php include("../Common/topbar.php"); ?>

  <!-- Top Bar End -->

  <!-- ========== Left Sidebar Start ========== -->

  <?php include("../Common/left-sidebar.php"); ?>

  <!-- Left Sidebar End -->  

  <!-- ============================================================== --> 

  <!-- Start right Content here --> 

  <!-- ============================================================== -->

  <div class="content-page"> 

    <!-- Start content -->

    <div class="content">

      <div class="container-fluid">

        <div class="row">

          <div class="col-lg-12">

            <div class="row">

              <?php /*?><div class="col-lg-3">

                <div class="widget">

                  <div class="widget-body">

                    <div class="row">

                      <div class="col-md-12 col-sm-12 col-xs-12"> <a href="#" data-toggle="modal" data-target="#add-category" class="btn btn-lg btn-success btn-block waves-effect waves-light"> <i class="fa fa-plus"></i> Create New </a>

                        <div id="external-events" class="m-t-20"> <br>

                          <p>Drag and drop your event or click in the calendar</p>

                          

                          

                          

                          <div class="external-event bg-purple" data-class="bg-purple"> <i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>Create New theme </div>

                        </div>

                        

                        <!-- checkbox -->

                        <div class="checkbox m-t-40" style="display:none;">

                          <input id="drop-remove" type="checkbox" checked>

                          <label for="drop-remove"> Remove after drop </label>

                        </div>

                      </div>

                    </div>

                  </div>

                </div>

              </div><?php */?>

              <!-- end col-->

              <div class="col-lg-12">

                <div class="card-box">

                  <div id="calendar"></div>

                </div>

              </div>

              <!-- end col --> 

            </div>

            <!-- end row --> 

            

            <!-- BEGIN MODAL -->

            <div class="modal fade none-border" id="event-modal">

              <div class="modal-dialog">

                <div class="modal-content">

                  <div class="modal-header">

                    <h4 class="modal-title mt-0"><strong>Add New Event</strong></h4>

                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>

                  </div>

                  <div class="modal-body"></div>

                  <div class="modal-footer">

                    <button type="button" class="btn btn-light waves-effect" data-dismiss="modal">Close</button>

                    <button type="button" class="btn btn-success save-event waves-effect waves-light">Create event</button>

                    <button type="button" class="btn btn-danger delete-event waves-effect waves-light" data-dismiss="modal">Delete</button>

                  </div>

                </div>

              </div>

            </div>

            

            <!-- Modal Add Category -->

            <div class="modal fade none-border" id="add-category">

              <div class="modal-dialog">

                <div class="modal-content">

                  <div class="modal-header">

                    <h4 class="modal-title mt-0"><strong>Add a category </strong></h4>

                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>

                  </div>

                  <div class="modal-body">

                    <form role="form">

                      <div class="row">

                        <div class="col-md-6">

                          <label class="control-label">Category Name</label>

                          <input class="form-control form-white" placeholder="Enter name" type="text" name="category-name"/>

                        </div>

                        <div class="col-md-6">

                          <label class="control-label">Choose Color</label>

                          <select class="form-control form-white" data-placeholder="Choose a color..." name="category-color">

                            <option value="success">Green</option>

                            <option value="danger">Red</option>

                            <option value="info">Cyan</option>

                            <option value="pink">Pink</option>

                            <option value="primary">Blue</option>

                            <option value="warning">Yellow</option>

                            <option value="inverse">Gray</option>

                          </select>

                        </div>

                      </div>

                    </form>

                  </div>

                  <div class="modal-footer">

                    <button type="button" class="btn btn-light waves-effect" data-dismiss="modal">Close</button>

                    <button type="button" class="btn btn-danger waves-effect waves-light save-category" data-dismiss="modal">Save</button>

                  </div>

                </div>

              </div>

            </div>

            <!-- END MODAL --> 

          </div>

          <!-- end col-12 --> 

        </div>

        <!-- end row --> 

        

      </div>

      <!-- container --> 

      

    </div>

    <!-- content -->

    

    <footer class="footer text-right"> <?php echo $footer_copyrights; ?> </footer>

  </div>

  <!-- ============================================================== --> 

  <!-- End Right content here --> 

  <!-- ============================================================== -->  

  <!-- Right Sidebar -->

  <?php include("../Common/right-sidebar.php"); ?>

  <!-- /Right-bar -->

</div>

<!-- END wrapper --> 

<?php include("../Common/footer.php"); ?>

<!-- Jquery-Ui --> 

<script src="<?php echo $WebLink; ?>assets/plugins/jquery-ui/jquery-ui.min.js"></script> 



<!-- SCRIPTS --> 

<script src="<?php echo $WebLink; ?>assets/plugins/moment/moment.js"></script> 

<script src='<?php echo $WebLink; ?>assets/plugins/fullcalendar/js/fullcalendar.min.js'></script> 

<script <?php /*?>src="<?php echo $WebLink; ?>assets/pages/jquery.fullcalendar.js"<?php */?>>
!function($) {
    "use strict";

    var CalendarApp = function() {
        this.$body = $("body")
        this.$modal = $('#event-modal'),
            this.$event = ('#external-events div.external-event'),
            this.$calendar = $('#calendar'),
            this.$saveCategoryBtn = $('.save-category'),
            this.$categoryForm = $('#add-category form'),
            this.$extEvents = $('#external-events'),
            this.$calendarObj = null
    };


    /* on drop */
    CalendarApp.prototype.onDrop = function (eventObj, date) {
        var $this = this;
        // retrieve the dropped element's stored Event Object
        var originalEventObject = eventObj.data('eventObject');
        var $categoryClass = eventObj.attr('data-class');
        // we need to copy it, so that multiple events don't have a reference to the same object
        var copiedEventObject = $.extend({}, originalEventObject);
        // assign it the date that was reported
        copiedEventObject.start = date;
        if ($categoryClass)
            copiedEventObject['className'] = [$categoryClass];
        // render the event on the calendar
        $this.$calendar.fullCalendar('renderEvent', copiedEventObject, true);
        // is the "remove after drop" checkbox checked?
        if ($('#drop-remove').is(':checked')) {
            // if so, remove the element from the "Draggable Events" list
            eventObj.remove();
        }
    },
        /* on click on event */
        CalendarApp.prototype.onEventClick =  function (calEvent, jsEvent, view) {
			//console.dir(calEvent);
            var $this = this;
            var form = $("<form></form>");
            form.append("<label>Change event name</label>");
            form.append("<div class='input-group m-b-15'><input class='form-control' type=text value='" + calEvent.title + "' /><span class='input-group-append'><button type='submit' class='btn btn-success btn-md waves-effect waves-light'><i class='fa fa-check'></i> Save</button></span></div>");
            $this.$modal.modal({
                backdrop: 'static'
            });
            $this.$modal.find('.delete-event').show().end().find('.save-event').hide().end().find('.modal-body').empty().prepend(form).end().find('.delete-event').unbind('click').click(function () {
                $this.$calendarObj.fullCalendar('removeEvents', function (ev) {
					//console.dir(ev.title);
					//console.dir(calEvent.title);
					DeleteEvent(calEvent.title);
                    return (ev._id == calEvent._id);
                });
                $this.$modal.modal('hide');
            });
            $this.$modal.find('form').on('submit', function () {
                calEvent.title = form.find("input[type=text]").val();
                $this.$calendarObj.fullCalendar('updateEvent', calEvent);
                $this.$modal.modal('hide');
                return false;
            });
        },
        /* on select */
        CalendarApp.prototype.onSelect = function (start, end, allDay) {
            var $this = this;
            $this.$modal.modal({
                backdrop: 'static'
            });
            var form = $("<form></form>");
            form.append("<div class='row'></div>");
            form.find(".row")
                .append("<div class='col-md-12'><div class='form-group'><label class='control-label'>Event Name</label><input class='form-control' placeholder='Insert Event Name' type='text' name='title'/></div></div>")
				.append("<div class='col-md-12'><div class='form-group'><label class='control-label'>Event Description</label><textarea class='form-control' placeholder='Insert Event Description' type='text' name='description'></textarea></div></div>")
/*                .append("<div class='col-md-12'><div class='form-group'><label class='control-label'>Event Beginning</label><input class='form-control' placeholder='Insert Event Name' type='datetime-local' name='beginning'/></div></div>")
				.append("<div class='col-md-6'><div class='form-group'><label class='control-label'>Event Ending Date</label><input class='form-control' placeholder='Insert Event Name' type='date' name='ending-date'/></div></div>")
				.append("<div class='col-md-6'><div class='form-group'><label class='control-label'>Event Ending Time</label><input class='form-control' placeholder='Insert Event Name' type='time' name='ending-time'/></div></div>")*/
                .append("<div class='col-md-12'><div class='form-group'><label class='control-label'>Category</label><select class='form-control' name='category'></select></div></div>")
                .find("select[name='category']")
                .append("<option value='bg-nblack'>Danger</option>")
                .append("<option value='bg-danger'>Warning</option>")
                .append("<option value='bg-warning'>Info</option>")
                .append("<option value='bg-norange'>Meeting </option>");
            $this.$modal.find('.delete-event').hide().end().find('.save-event').show().end().find('.modal-body').empty().prepend(form).end().find('.save-event').unbind('click').click(function () {
                form.submit();
            });
            $this.$modal.find('form').on('submit', function () {
                var title = form.find("input[name='title']").val();
				var description = form.find("textarea[name='description']").val();
                //var start = form.find("input[name='beginning']").val();
                //var end = form.find("input[name='ending-date']").val() + ' ' + form.find("input[name='ending-time']").val();
                var categoryClass = form.find("select[name='category'] option:checked").val();
                if (title !== null && title.length != 0) {
					AddData(title,description,start,end,categoryClass);
                    $this.$calendarObj.fullCalendar('renderEvent', {
                        title: title,
                        start:start,
                        end: end,
                        allDay: false,
                        className: categoryClass
                    }, true);
                    $this.$modal.modal('hide');
                }
                else{
                    alert('You have to give a title to your event');
                }
                return false;

            });
            $this.$calendarObj.fullCalendar('unselect');
        },
        CalendarApp.prototype.enableDrag = function() {
            //init events
            $(this.$event).each(function () {
                // create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
                // it doesn't need to have a start or end
                var eventObject = {
                    title: $.trim($(this).text()) // use the element's text as the event title
                };
                // store the Event Object in the DOM element so we can get to it later
                $(this).data('eventObject', eventObject);
                // make the event draggable using jQuery UI
                $(this).draggable({
                    zIndex: 999,
                    revert: true,      // will cause the event to go back to its
                    revertDuration: 0  //  original position after the drag
                });
            });
        }
    /* Initializing */
    CalendarApp.prototype.init = function() {
        this.enableDrag();
        /*  Initialize the calendar  */
        var date = new Date();
        var d = date.getDate();
        var m = date.getMonth();
        var y = date.getFullYear();
        var form = '';
        var today = new Date($.now());
		
        var defaultEvents =  [
		<?php
		$events = mysqli_query($_SESSION['con'],"SELECT * FROM events WHERE user_id='".$_SESSION["id"]."' ORDER BY id asc");
		$cuma = '';
		while($rows=mysqli_fetch_array($events)){
		echo $cuma . "{
            title: '".$rows['title']."',
            start: ".$rows['eventstart'].",
			end: ".$rows['eventend'].",
            className: '".$rows['category']."'
        }"; $cuma = ','; }?>];

        var $this = this;
        $this.$calendarObj = $this.$calendar.fullCalendar({
            slotDuration: '00:15:00', /* If we want to split day time each 15minutes */
            minTime: '00:00:00',
            maxTime: '23:59:00',
            defaultView: 'month',
            handleWindowResize: true,
            height: $(window).height() - 200,
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,agendaWeek,agendaDay'
            },
            events: defaultEvents,
            editable: true,
            droppable: true, // this allows things to be dropped onto the calendar !!!
            eventLimit: true, // allow "more" link when too many events
            selectable: true,
            drop: function(date) { $this.onDrop($(this), date); },
            select: function (start, end, allDay) { $this.onSelect(start, end, allDay); },
            eventClick: function(calEvent, jsEvent, view) { $this.onEventClick(calEvent, jsEvent, view); }

        });

        //on new event
        this.$saveCategoryBtn.on('click', function(){
            var categoryName = $this.$categoryForm.find("input[name='category-name']").val();
            var categoryColor = $this.$categoryForm.find("select[name='category-color']").val();
            if (categoryName !== null && categoryName.length != 0) {
				alert(categoryName);
                $this.$extEvents.append('<div class="external-event bg-' + categoryColor + '" data-class="bg-' + categoryColor + '" style="position: relative;"><i class="mdi mdi-checkbox-blank-circle mr-2 vertical-middle"></i>' + categoryName + '</div>')
                $this.enableDrag();
            }

        });
    },

        //init CalendarApp
        $.CalendarApp = new CalendarApp, $.CalendarApp.Constructor = CalendarApp

}(window.jQuery),

//initializing CalendarApp
    function($) {
        "use strict";
        $.CalendarApp.init()
    }(window.jQuery);

function AddData(title,description,start,end,category){
	$.ajax({
		type:'POST',
		url:'ajaxData.php',
		dataType: 'json',
		data:'action=AddEvent&title=' + title + '&description=' + description + '&start=' + start + '&end=' + end + '&category=' + category,
		success:function(data){
		getNotifications('load');
			//$('#'+show).html(data.rows);
			//$('#pageFrom').html((data.LimitFrom + 1));
			//$('#pageTo').html(data.LimitTotal);
			//$('#pageTotal').html(data.TotalRecords);
			//$('.pagination').html(data.pagination);
			//$('.table-responsive').responsiveTable({addDisplayAllBtn: 'btn btn-secondary'});
		}
	});
}

function DeleteEvent(title){
	$.ajax({
		type:'POST',
		url:'ajaxData.php',
		dataType: 'json',
		data:'action=DeleteEvent&title=' + title,
		success:function(data){
		getNotifications('load');
			//$('#'+show).html(data.rows);
			//$('#pageFrom').html((data.LimitFrom + 1));
			//$('#pageTo').html(data.LimitTotal);
			//$('#pageTotal').html(data.TotalRecords);
			//$('.pagination').html(data.pagination);
			//$('.table-responsive').responsiveTable({addDisplayAllBtn: 'btn btn-secondary'});
		}
	});
}
</script>

<?php include("../Common/bottom.php"); ?>

</body>

</html>