<?php
// Database Connection
$host = "localhost";
$user = "trojanli_crmmoiz"; // Change if needed
$pass = '}]GxQMzUUsgw'; // Change if needed
$dbname = "trojanli_crmmoiz"; // Change to your DB name

// --- Basic hardening for long exports ---
set_time_limit(0);
ini_set('memory_limit', '1024M');

// --- DB connection ---
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
  http_response_code(500);
  die("Connection failed: " . $conn->connect_error);
}

// --- Shared SELECT with JOINs (same as report.php) ---
$baseSelect = "SELECT 
    l.SerialNumber, l.CompanyName, l.ContactPerson, l.Country, l.CellPhone, l.PostDate,
    i1.title AS MainQuerySource, i2.title AS MainQueryType, i3.title AS Status,
    i4.title AS CustomerType,
    u1.ContactPerson AS AssignManager, u2.ContactPerson AS FollowupID
FROM leads l
LEFT JOIN importanttitles i1 ON l.MainQuerySource = i1.id
LEFT JOIN importanttitles i2 ON l.MainQueryType   = i2.id
LEFT JOIN importanttitles i3 ON l.Status          = i3.id
LEFT JOIN importanttitles i4 ON l.CustomerType    = i4.id
LEFT JOIN users u1 ON l.AssignManager = u1.id
LEFT JOIN users u2 ON l.FollowupID   = u2.id";

// --- WHERE builder helpers (same as report.php) ---
$whereParts = [];
$params = [];
$types = "";

function addLike(&$whereParts, &$params, &$types, $col, $val) {
  if (isset($val) && $val !== '') {
    $whereParts[] = "$col LIKE ?";
    $params[] = "%$val%";
    $types .= "s";
  }
}
function addEq(&$whereParts, &$params, &$types, $col, $val) {
  if (isset($val) && $val !== '') {
    $whereParts[] = "$col = ?";
    $params[] = $val;
    $types .= "s";
  }
}

// --- Collect filters from GET (MUST mirror report.php) ---
addLike($whereParts,$params,$types,"l.SerialNumber",   $_GET['SerialNumber']   ?? '');
addLike($whereParts,$params,$types,"l.CompanyName",    $_GET['CompanyName']    ?? '');
addLike($whereParts,$params,$types,"l.ContactPerson",  $_GET['ContactPerson']  ?? '');
addLike($whereParts,$params,$types,"l.Country",        $_GET['Country']        ?? '');
addLike($whereParts,$params,$types,"l.CellPhone",      $_GET['CellPhone']      ?? '');

addEq($whereParts,$params,$types,"i1.id", $_GET['MainQuerySource'] ?? '');
addEq($whereParts,$params,$types,"i2.id", $_GET['MainQueryType']   ?? '');
addEq($whereParts,$params,$types,"i3.id", $_GET['Status']          ?? '');
addEq($whereParts,$params,$types,"i4.id", $_GET['CustomerType']    ?? '');
addEq($whereParts,$params,$types,"u1.id", $_GET['AssignManager']   ?? '');
addEq($whereParts,$params,$types,"u2.id", $_GET['FollowupID']      ?? '');

if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {
  $whereParts[] = "l.PostDate BETWEEN ? AND ?";
  $params[] = $_GET['from_date'];
  $params[] = $_GET['to_date'];
  $types .= "ss";
}

$where = $whereParts ? (" WHERE " . implode(" AND ", $whereParts)) : "";

// --- Final export SQL: NO LIMIT/OFFSET ---
$sql = "$baseSelect $where ORDER BY l.PostDate DESC";

// --- Prepare & execute ---
$stmt = $conn->prepare($sql);
if ($stmt === false) {
  http_response_code(500);
  die("Prepare failed: " . $conn->error);
}
if ($types) {
  $stmt->bind_param($types, ...$params);
}
if (!$stmt->execute()) {
  http_response_code(500);
  die("Execute failed: " . $stmt->error);
}
$res = $stmt->get_result();

// --- CSV headers (UTF-8 BOM so Excel shows Unicode correctly) ---
header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="leads_data.csv"');
echo "\xEF\xBB\xBF"; // BOM

$out = fopen('php://output', 'w');

// --- Column headers (fixed order) ---
fputcsv($out, [
  'Serial Number','Company Name','Contact Person','Country','Cell Phone',
  'Post Date','Query Source','Query Type','Status','Customer Type',
  'Assign Manager','Followup'
]);

// --- Stream rows ---
while ($row = $res->fetch_assoc()) {
  fputcsv($out, [
    $row['SerialNumber'],
    $row['CompanyName'],
    $row['ContactPerson'],
    $row['Country'],
    $row['CellPhone'],
    $row['PostDate'],
    $row['MainQuerySource'],
    $row['MainQueryType'],
    $row['Status'],
    $row['CustomerType'],
    $row['AssignManager'],
    $row['FollowupID'],
  ]);
}
fclose($out);

$stmt->close();
$conn->close();
exit;
