<?php
include("../Common/top.php");
$PageTitle = 'Report';

if (!in_array('report', $_SESSION["Permissions"])) {
  header("location:" . $WebLink . "dashboard.php");
  exit;
}

$conn = $_SESSION['con'];
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

/** ------------------------------
 * Build SELECT & WHERE (reusable)
 * ------------------------------ */
$baseSelect = "SELECT 
    l.SerialNumber, l.CompanyName, l.ContactPerson, l.Country, l.CellPhone, l.PostDate,
    i1.title AS MainQuerySource, i4.title AS CustomerType, i2.title AS MainQueryType, i3.title AS Status,
    u1.ContactPerson AS AssignManager, u2.ContactPerson AS FollowupID
FROM leads l
LEFT JOIN importanttitles i1 ON l.MainQuerySource = i1.id
LEFT JOIN importanttitles i2 ON l.MainQueryType = i2.id
LEFT JOIN importanttitles i3 ON l.Status = i3.id
LEFT JOIN importanttitles i4 ON l.CustomerType = i4.id
LEFT JOIN users u1 ON l.AssignManager = u1.id
LEFT JOIN users u2 ON l.FollowupID = u2.id";


$whereParts = [];
$params = [];
$types = "";

function addLike(&$whereParts, &$params, &$types, $col, $val) {
  if (isset($val) && $val !== '') {
    $whereParts[] = "$col LIKE ?";
    $params[] = "%$val%";
    $types .= "s";
  }
}
function addEq(&$whereParts, &$params, &$types, $col, $val) {
  if (isset($val) && $val !== '') {
    $whereParts[] = "$col = ?";
    $params[] = $val;
    $types .= "s";
  }
}

// Collect filters from GET
addLike($whereParts,$params,$types,"l.SerialNumber",   $_GET['SerialNumber']   ?? '');
addLike($whereParts,$params,$types,"l.CompanyName",    $_GET['CompanyName']    ?? '');
addLike($whereParts,$params,$types,"l.ContactPerson",  $_GET['ContactPerson']  ?? '');
addLike($whereParts,$params,$types,"l.Country",        $_GET['Country']        ?? '');
addLike($whereParts,$params,$types,"l.CellPhone",      $_GET['CellPhone']      ?? '');

addEq($whereParts,$params,$types,"i4.id", $_GET['CustomerType']      ?? '');
addEq($whereParts,$params,$types,"i1.id", $_GET['MainQuerySource'] ?? '');
addEq($whereParts,$params,$types,"i2.id", $_GET['MainQueryType']   ?? '');
addEq($whereParts,$params,$types,"i3.id", $_GET['Status']          ?? '');
addEq($whereParts,$params,$types,"u1.id", $_GET['AssignManager']   ?? '');
addEq($whereParts,$params,$types,"u2.id", $_GET['FollowupID']      ?? '');

if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {
  $whereParts[] = "l.PostDate BETWEEN ? AND ?";
  $params[] = $_GET['from_date'];
  $params[] = $_GET['to_date'];
  $types .= "ss";
}

$where = $whereParts ? (" WHERE " . implode(" AND ", $whereParts)) : "";

/** ------------------------------
 * Pagination
 * ------------------------------ */
$limit  = 100;
$page   = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($page - 1) * $limit;

/** ------------------------------
 * Data query (LIMIT/OFFSET)
 * ------------------------------ */
$sql = "$baseSelect $where ORDER BY l.PostDate DESC LIMIT ? OFFSET ?";
$paramsData = $params;
$typesData  = $types . "ii";
$paramsData[] = $limit;
$paramsData[] = $offset;

$stmt = $conn->prepare($sql);
$stmt->bind_param($typesData, ...$paramsData);
$stmt->execute();
$result = $stmt->get_result();

/** ------------------------------
 * Total count (same WHERE, no LIMIT)
 * ------------------------------ */
$countSql = "SELECT COUNT(*) AS cnt
FROM leads l
LEFT JOIN importanttitles i1 ON l.MainQuerySource = i1.id
LEFT JOIN importanttitles i2 ON l.MainQueryType   = i2.id
LEFT JOIN importanttitles i3 ON l.Status          = i3.id
LEFT JOIN importanttitles i4 ON l.CustomerType    = i4.id
LEFT JOIN users u1 ON l.AssignManager = u1.id
LEFT JOIN users u2 ON l.FollowupID   = u2.id
$where";

$stmtCnt = $conn->prepare($countSql);
if ($types) { $stmtCnt->bind_param($types, ...$params); }
$stmtCnt->execute();
$total_rows = (int)$stmtCnt->get_result()->fetch_assoc()['cnt'];
$total_pages = max(1, (int)ceil($total_rows / $limit));

/** ------------------------------
 * For pagination links: keep filters
 * ------------------------------ */
$query = $_GET;
unset($query['page']);
$baseQS = http_build_query($query);
$baseQS = $baseQS ? $baseQS . '&' : '';
?>
<!DOCTYPE html>
<html>
<head>
  <style>
    .table-responsive[data-pattern="priority-columns"]>.table>thead>tr>th,
    .table-responsive[data-pattern="priority-columns"]>.table>tbody>tr>th,
    .table-responsive[data-pattern="priority-columns"]>.table>tfoot>tr>th,
    .table-responsive[data-pattern="priority-columns"]>.table>thead>tr>td,
    .table-responsive[data-pattern="priority-columns"]>.table>tbody>tr>td,
    .table-responsive[data-pattern="priority-columns"]>.table>tfoot>tr>td {
      white-space: normal !important;
    }
    .pagination {
      display: flex;
      justify-content: center;
      gap: 8px;
      margin: 20px 0;
    }
    .pagination a {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 40px; height: 40px;
      text-decoration: none; color: #333;
      background-color: #f0f0f0;
      border: 2px solid #ccc; border-radius: 6px;
      font-weight: bold; transition: all 0.3s ease;
    }
    .pagination a:hover {
      background-color: #007BFF; color: #fff; border-color: #007BFF;
    }
    .pagination a.active {
      background-color: #007BFF; color: #fff; border-color: #007BFF; pointer-events: none;
    }
  </style>
  <?php include("../Common/meta.php"); ?>
  <title>Users | CRM</title>
  <?php include("../Common/head.php"); ?>
  <link href="<?php echo $WebLink; ?>assets/plugins/responsive-table/css/rwd-table.min.css" rel="stylesheet" type="text/css" media="screen">
</head>
<body class="fixed-left">
<div id="wrapper">
  <?php include("../Common/topbar.php"); ?>
  <?php include("../Common/left-sidebar.php"); ?>

  <div class="content-page">
    <div class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card-box">

              <!-- Filters -->
              <form method="GET">
                <label>Serial Number:</label>
                <input type="text" name="SerialNumber" value="<?= htmlspecialchars($_GET['SerialNumber'] ?? '') ?>">

                <label>Company Name:</label>
                <input type="text" name="CompanyName" value="<?= htmlspecialchars($_GET['CompanyName'] ?? '') ?>">

                <label>Contact Person:</label>
                <input type="text" name="ContactPerson" value="<?= htmlspecialchars($_GET['ContactPerson'] ?? '') ?>">

                <label>Country:</label>
                <input type="text" name="Country" value="<?= htmlspecialchars($_GET['Country'] ?? '') ?>">

                <label>Cell Phone:</label>
                <input type="text" name="CellPhone" value="<?= htmlspecialchars($_GET['CellPhone'] ?? '') ?>">
                
                <label>Customer Type:</label>
                <select name="CustomerType">
                  <option value="">--Select--</option>
                  <?php
                  $q1 = $conn->query("SELECT DISTINCT i.id, i.title FROM leads l JOIN importanttitles i ON l.CustomerType = i.id");
                  while ($row = $q1->fetch_assoc()) {
                    $sel = (($_GET['CustomerType'] ?? '') == $row['id']) ? "selected" : "";
                    echo "<option value='".htmlspecialchars($row['id'])."' $sel>".htmlspecialchars($row['title'])."</option>";
                  }
                  ?>
                </select>
                
                <label>Query Source:</label>
                <select name="MainQuerySource">
                  <option value="">--Select--</option>
                  <?php
                  $q1 = $conn->query("SELECT DISTINCT i.id, i.title FROM leads l JOIN importanttitles i ON l.MainQuerySource = i.id");
                  while ($row = $q1->fetch_assoc()) {
                    $sel = (($_GET['MainQuerySource'] ?? '') == $row['id']) ? "selected" : "";
                    echo "<option value='".htmlspecialchars($row['id'])."' $sel>".htmlspecialchars($row['title'])."</option>";
                  }
                  ?>
                </select>

                <label>Query Type:</label>
                <select name="MainQueryType">
                  <option value="">--Select--</option>
                  <?php
                  $q2 = $conn->query("SELECT DISTINCT i.id, i.title FROM leads l JOIN importanttitles i ON l.MainQueryType = i.id");
                  while ($row = $q2->fetch_assoc()) {
                    $sel = (($_GET['MainQueryType'] ?? '') == $row['id']) ? "selected" : "";
                    echo "<option value='".htmlspecialchars($row['id'])."' $sel>".htmlspecialchars($row['title'])."</option>";
                  }
                  ?>
                </select>

                <label>Status:</label>
                <select name="Status">
                  <option value="">--Select--</option>
                  <?php
                  $q3 = $conn->query("SELECT DISTINCT i.id, i.title FROM leads l JOIN importanttitles i ON l.Status = i.id");
                  while ($row = $q3->fetch_assoc()) {
                    $sel = (($_GET['Status'] ?? '') == $row['id']) ? "selected" : "";
                    echo "<option value='".htmlspecialchars($row['id'])."' $sel>".htmlspecialchars($row['title'])."</option>";
                  }
                  ?>
                </select>

                <label>From Date:</label>
                <input type="date" name="from_date" value="<?= htmlspecialchars($_GET['from_date'] ?? '') ?>">

                <label>To Date:</label>
                <input type="date" name="to_date" value="<?= htmlspecialchars($_GET['to_date'] ?? '') ?>">

                <button type="submit">Filter</button>
                <a href="https://portal.trojanlimited.com/Reports/report.php"><button type="button" type="button">Reset</button></a>
              </form>

              <!-- Export all filtered rows (GET – no LIMIT in download.php) -->
              <form action="download.php" method="GET" style="margin-top:12px;">
                <input type="hidden" name="SerialNumber"    value="<?= htmlspecialchars($_GET['SerialNumber']   ?? '') ?>">
                <input type="hidden" name="CompanyName"     value="<?= htmlspecialchars($_GET['CompanyName']    ?? '') ?>">
                <input type="hidden" name="ContactPerson"   value="<?= htmlspecialchars($_GET['ContactPerson']  ?? '') ?>">
                <input type="hidden" name="Country"         value="<?= htmlspecialchars($_GET['Country']        ?? '') ?>">
                <input type="hidden" name="CellPhone"       value="<?= htmlspecialchars($_GET['CellPhone']      ?? '') ?>">
                <input type="hidden" name="CustomerType"       value="<?= htmlspecialchars($_GET['CustomerType']      ?? '') ?>">
                <input type="hidden" name="MainQuerySource" value="<?= htmlspecialchars($_GET['MainQuerySource']?? '') ?>">
                <input type="hidden" name="MainQueryType"   value="<?= htmlspecialchars($_GET['MainQueryType']  ?? '') ?>">
                <input type="hidden" name="Status"          value="<?= htmlspecialchars($_GET['Status']         ?? '') ?>">
                <input type="hidden" name="AssignManager"   value="<?= htmlspecialchars($_GET['AssignManager']  ?? '') ?>">
                <input type="hidden" name="FollowupID"      value="<?= htmlspecialchars($_GET['FollowupID']     ?? '') ?>">
                <input type="hidden" name="from_date"       value="<?= htmlspecialchars($_GET['from_date']      ?? '') ?>">
                <input type="hidden" name="to_date"         value="<?= htmlspecialchars($_GET['to_date']        ?? '') ?>">
                <button type="submit">Download CSV</button>
              </form>
              <br/>

              <div class="table-rep-plugin">
                <div class="table-responsive" data-pattern="priority-columns">
                  <table id="tech-companies-1" class="table table-striped">
                    <thead>
                      <tr>
                        <th>Serial Number</th>
                        <th>Company Name</th>
                        <th data-priority="3">Contact Person</th>
                        <th data-priority="3">Country</th>
                        <th data-priority="6">Cell Phone</th>
                        <th data-priority="6">Customer Type</th>
                        <th data-priority="6">Post Date</th>
                        <th data-priority="6">Query Source</th>
                        <th data-priority="6">Query Type</th>
                        <th data-priority="1">Status</th>
                        <th data-priority="1">Assign Manager</th>
                        <th data-priority="1">Followup</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                          <td><?= htmlspecialchars($row["SerialNumber"]) ?></td>
                          <td><?= htmlspecialchars($row["CompanyName"]) ?></td>
                          <td><?= htmlspecialchars($row["ContactPerson"]) ?></td>
                          <td><?= htmlspecialchars($row["Country"]) ?></td>
                          <td><?= htmlspecialchars($row["CellPhone"]) ?></td>
                          <td><?= htmlspecialchars($row["CustomerType"]) ?></td>
                          <td><?= htmlspecialchars($row["PostDate"]) ?></td>
                          <td><?= htmlspecialchars($row["MainQuerySource"]) ?></td>
                          <td><?= htmlspecialchars($row["MainQueryType"]) ?></td>
                          <td><?= htmlspecialchars($row["Status"]) ?></td>
                          <td><?= htmlspecialchars($row["AssignManager"]) ?></td>
                          <td><?= htmlspecialchars($row["FollowupID"]) ?></td>
                        </tr>
                      <?php endwhile; ?>
                    </tbody>
                  </table>
                </div>

                <!-- Pagination -->
                <div class="row">
                  <div class="col-sm-12 col-md-5">
                    <div class="pagination">
                      <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <a href="?<?= $baseQS ?>page=<?= $i ?>" class="<?= ($i == $page) ? 'active' : '' ?>"><?= $i ?></a>
                      <?php endfor; ?>
                    </div>
                  </div>
                  <div class="col-sm-12 col-md-7">
                    <div class="dataTables_paginate paging_simple_numbers">
                      <ul class="pagination"></ul>
                    </div>
                  </div>
                </div>

              </div> <!-- /.table-rep-plugin -->

            </div>
          </div>
        </div>
      </div>
    </div>

    <footer class="footer text-right">
      <?php echo $footer_copyrights; ?>
    </footer>
  </div>

  <?php include("../Common/right-sidebar.php"); ?>
</div>

<?php include("../Common/footer.php"); ?>
<script src="<?php echo $WebLink; ?>assets/plugins/responsive-table/js/rwd-table.min.js" type="text/javascript"></script>
<?php include("../Common/bottom.php"); ?>
</body>
</html>
